/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.BadFilesBean;
import com.ibm.hwmca.base.logd.CreateEventLogData;
import com.ibm.hwmca.base.logd.EventLogData;
import com.ibm.hwmca.base.logd.LogErrorIdsLogD;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtil;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtilException;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.DateTimePattern;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileFn
implements LogErrorIdsLogD {
    private static final String TRACE_MASKT = "XLOGDTWT";
    private static final String TRACE_MASKF = "XLOGDTWF";
    private static final String TRACE_MASKD = "XLOGDTWD";
    private static final String BLANKS = "                    ";
    private static final String SPACE = "  ";
    private static final String ZIPPY = "ZipTheFiles";
    private static final String SAVE_TO_FILE = "SaveToFile";
    private static final char NEW_LINE = '\n';
    private static final char END_OF_STRING = '\u0000';
    private static final int NAME_LENGTH = 12;
    private static final int TIME_LENGTH = 14;
    private Log[] _logData = null;
    private String _text = null;
    private int _zipCount;
    private int _howManySelected;
    private ArrayList _badFiles;
    private static final LocalizableText _lWriteBusy = new LocalizableText(BaseTextBundle.getBundleName(), "logd.write.busy");
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogDisplayer");
    CreateEventLogData _createEventLogData = new CreateEventLogData();
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.logd.res.LogDisplayerRes";
    private static final String BAD_FILES_PANEL_NAME = "BadFilesPanel";
    private static final LocalizableText _lSaveToFileTitle = new LocalizableText(BaseTextBundle.getBundleName(), "logd.file.title");
    private static final LocalizableText _lZipFileTitle = new LocalizableText(BaseTextBundle.getBundleName(), "logd.file.displayer.title");
    private boolean _releaseDevice = false;
    private MediaServicesUtil _mediaServicesUtil;
    MediaDeviceIdentifier _mediaDeviceIdentifier;
    private boolean _loggedAlready = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeToFile(PanelTasklet panelTasklet, PanelTaskletResponse taskletResponse, String realFileName) throws HException {
        block29: {
            Trace.trace(TRACE_MASKT, "-> FileFn.writeToFile()");
            OutputStreamWriter out = null;
            File tmpSaveFile = null;
            String tmpSaveFileName = null;
            boolean busyDisplayed = false;
            String deviceType = null;
            boolean writeOk = false;
            try {
                deviceType = this.queryMediaType(panelTasklet, realFileName);
                panelTasklet.showBusyDialog(_lSaveToFileTitle, _lWriteBusy);
                busyDisplayed = true;
                if (deviceType != null) {
                    File directory = new File(BaseFileControl.getFilePath("tmp"));
                    tmpSaveFile = File.createTempFile("LogSave", ".trm", directory);
                    tmpSaveFileName = tmpSaveFile.getAbsolutePath();
                    Trace.trace(TRACE_MASKF, "tmp save file Name =[" + tmpSaveFileName + "]");
                } else {
                    realFileName = FileFn.fullyQualify(realFileName);
                    tmpSaveFile = new File(realFileName);
                    tmpSaveFileName = realFileName;
                }
                out = new FileWriter(tmpSaveFile);
                if (this._logData != null) {
                    Trace.trace(TRACE_MASKF, "Saving log event list to a file.");
                    EventLogData[] eventLogData = new EventLogData[]{new EventLogData()};
                    CreateEventLogData createEventLogData = new CreateEventLogData();
                    int len = this._logData.length;
                    StringBuffer strBuffer = new StringBuffer(30);
                    Date timeStamp = null;
                    UserContext userContext = UserContext.getCurrentUserContext();
                    Locale locale = userContext.getLocale();
                    DateFormat datePattern = DateTimePattern.getDatePattern(locale);
                    datePattern.setTimeZone(userContext.getTimeZone());
                    DateFormat timePattern = DateTimePattern.getTimeWithMillisecondsPattern(locale);
                    timePattern.setTimeZone(userContext.getTimeZone());
                    for (int i = 0; i < len; ++i) {
                        strBuffer.setLength(0);
                        createEventLogData.createEventLogData(this._logData, i, eventLogData);
                        strBuffer.append(eventLogData[0].getEventId() + SPACE);
                        timeStamp = eventLogData[0].getDate();
                        strBuffer.append(datePattern.format(timeStamp) + SPACE);
                        strBuffer.append(this.padBlank(timePattern.format(timeStamp), 14) + SPACE);
                        strBuffer.append(eventLogData[0].getType().toString() + SPACE);
                        strBuffer.append(this.padBlank(eventLogData[0].getName(), 12) + SPACE);
                        strBuffer.append(eventLogData[0].getData() + '\n');
                        out.write(strBuffer.toString());
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "Saving log text to a file.");
                    this._text = this._text.replace('\u0000', '\n');
                    out.write(this._text);
                }
                if (out != null) {
                    out.close();
                    out = null;
                }
                if (deviceType != null) {
                    this.writeToDevice(panelTasklet, taskletResponse, _lSaveToFileTitle, tmpSaveFile, realFileName, SAVE_TO_FILE);
                } else {
                    String[] arg = new String[]{tmpSaveFileName};
                    this.displayMsg(panelTasklet, taskletResponse, _lSaveToFileTitle, "LOGDNFILE", arg, MsgType.INFORMATION_MESSAGE);
                    Trace.trace(TRACE_MASKF, "The data was saved to the file=" + tmpSaveFileName);
                    if (!taskletResponse.isResponseSet()) {
                        taskletResponse.dispose();
                    }
                }
                writeOk = true;
                Object var21_22 = null;
                Trace.trace(TRACE_MASKF, "-> in finally.  FileFn.writeToFile()");
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ioe2) {
                    Trace.trace(TRACE_MASKF, "in writeToFile finally: Caught IOException closing file.");
                    Trace.trace(TRACE_MASKF, ioe2);
                }
                if (tmpSaveFile != null && (deviceType != null || deviceType == null && tmpSaveFile.canWrite() && !writeOk && tmpSaveFile.isFile())) {
                    tmpSaveFile.delete();
                }
                if (busyDisplayed) {
                    panelTasklet.destroyBusyDialog();
                    busyDisplayed = false;
                }
                break block29;
                {
                    catch (IOException ioe) {
                        Trace.trace(TRACE_MASKF, "In FileFn.writeToFile().. Caught IOException.");
                        Trace.trace(TRACE_MASKF, ioe);
                        this.displayMsg(panelTasklet, taskletResponse, _lSaveToFileTitle, "LOGDUFILE", MsgType.ERROR_MESSAGE);
                        Object var21_23 = null;
                        Trace.trace(TRACE_MASKF, "-> in finally.  FileFn.writeToFile()");
                        try {
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (IOException ioe2) {
                            Trace.trace(TRACE_MASKF, "in writeToFile finally: Caught IOException closing file.");
                            Trace.trace(TRACE_MASKF, ioe2);
                        }
                        if (tmpSaveFile != null && (deviceType != null || deviceType == null && tmpSaveFile.canWrite() && !writeOk && tmpSaveFile.isFile())) {
                            tmpSaveFile.delete();
                        }
                        if (busyDisplayed) {
                            panelTasklet.destroyBusyDialog();
                            busyDisplayed = false;
                        }
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    Object var21_24 = null;
                    Trace.trace(TRACE_MASKF, "-> in finally.  FileFn.writeToFile()");
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException ioe2) {
                        Trace.trace(TRACE_MASKF, "in writeToFile finally: Caught IOException closing file.");
                        Trace.trace(TRACE_MASKF, ioe2);
                    }
                    if (tmpSaveFile != null && (deviceType != null || deviceType == null && tmpSaveFile.canWrite() && !writeOk && tmpSaveFile.isFile())) {
                        tmpSaveFile.delete();
                    }
                    if (busyDisplayed) {
                        panelTasklet.destroyBusyDialog();
                        busyDisplayed = false;
                    }
                    throw throwable;
                }
            }
            catch (MediaServicesUtilException mse) {
                Trace.trace(TRACE_MASKF, "in writeToFile finally: Caught MediaServicesUtilException while querying device type.");
                Trace.trace(TRACE_MASKF, mse);
            }
        }
        Trace.trace(TRACE_MASKT, "<- FileFn.writeToFile()");
    }

    private String padBlank(String str, int count) {
        int len = str.length();
        if (len < count) {
            int padCount = count - len;
            str = str + BLANKS.substring(0, padCount);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDataToFile(PanelTasklet panelTasklet, PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException, HException {
        try {
            String fileName = (String)taskletRequest.getData("fileName");
            Trace.trace(TRACE_MASKF, "Save data to fileName=" + fileName);
            this.writeToFile(panelTasklet, taskletResponse, fileName);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Trace.trace(TRACE_MASKF, "in finally in FileFn.saveDataToFile(). cleanupReleaseDevice=" + this._releaseDevice);
            if (!taskletResponse.isResponseSet()) {
                taskletResponse.noAction();
            }
            throw throwable;
        }
        Trace.trace(TRACE_MASKF, "in finally in FileFn.saveDataToFile(). cleanupReleaseDevice=" + this._releaseDevice);
        if (!taskletResponse.isResponseSet()) {
            taskletResponse.noAction();
        }
    }

    private void doRelease(String whoIsCalling, MediaDevice mediaDevice) {
        block5: {
            try {
                Trace.trace(TRACE_MASKF, "in doRelease from " + whoIsCalling + ".  _release=" + this._releaseDevice);
                if (this._releaseDevice) {
                    Trace.trace(TRACE_MASKF, "Before releasing the device for " + whoIsCalling);
                    if (mediaDevice == null) {
                        Trace.trace(TRACE_MASKF, "mediaDevice is null");
                    } else {
                        mediaDevice.unlock();
                        this._releaseDevice = false;
                    }
                }
            }
            catch (MediaDeviceLockException mde) {
                Trace.trace(TRACE_MASKF, "MediaDeviceLockException caught in " + whoIsCalling);
                Trace.trace(TRACE_MASKF, mde);
                if (this._loggedAlready) break block5;
                new FrameworkLog(_logInfo, 1366, mde).log(FrameworkLogAttributes.INFO_LOG);
                this._loggedAlready = true;
            }
        }
    }

    public void saveToFile(PanelTasklet panelTasklet, PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse, Log[] logData) throws TaskletException, HException {
        Trace.trace(TRACE_MASKF, "Will be saving the event log image to a file");
        this._releaseDevice = false;
        this._loggedAlready = false;
        this._text = null;
        this._logData = logData;
        this.saveDataToFile(panelTasklet, taskletRequest, taskletResponse);
    }

    public void saveToFile(PanelTasklet panelTasklet, PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse, String text) throws TaskletException, HException {
        Trace.trace(TRACE_MASKF, "Will be saving the text data to a file");
        this._releaseDevice = false;
        this._loggedAlready = false;
        this._logData = null;
        this._text = text;
        this.saveDataToFile(panelTasklet, taskletRequest, taskletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void makeZipFile(PanelTasklet panelTasklet, PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse, String[] fileList, Integer[] listSelected) throws IOException, TaskletException, HException {
        block32: {
            Trace.trace(TRACE_MASKT, "-> FileFn.makeZipFile()");
            byte[] buf = new byte[1024];
            Trace.trace(TRACE_MASKT, "-> FileFn.makeZipFile()");
            this._loggedAlready = false;
            this._zipCount = 0;
            this._howManySelected = 0;
            this._badFiles = new ArrayList();
            String fileToZip = null;
            boolean busyDisplayed = false;
            String deviceType = null;
            fileToZip = null;
            File fileObj = null;
            int len = 0;
            boolean zipError = false;
            ZipEntry ze = null;
            ZipOutputStream zos = null;
            FileInputStream is = null;
            File tmpZipFile = null;
            String realZipFileName = null;
            String tmpZipFileName = null;
            boolean writeOk = false;
            Trace.trace(TRACE_MASKF, "-> FileFn.makeZipFile()");
            realZipFileName = (String)taskletRequest.getData("ZipFileName");
            Trace.trace(TRACE_MASKF, "real zip file Name =[" + realZipFileName + "]");
            realZipFileName = FileFn.fullyQualify(realZipFileName);
            try {
                try {
                    deviceType = this.queryMediaType(panelTasklet, realZipFileName);
                    try {
                        block30: {
                            panelTasklet.showBusyDialog(_lZipFileTitle, _lWriteBusy);
                            busyDisplayed = true;
                            if (deviceType != null) {
                                File directory = new File(BaseFileControl.getFilePath("tmp"));
                                tmpZipFile = File.createTempFile("LogZip", ".zip", directory);
                                tmpZipFileName = tmpZipFile.getName();
                                Trace.trace(TRACE_MASKF, "tmp zip file Name =[" + tmpZipFileName + "]");
                            } else {
                                tmpZipFile = new File(realZipFileName);
                                tmpZipFileName = realZipFileName;
                            }
                            this._howManySelected = listSelected.length;
                            for (int i = 0; i < this._howManySelected && !zipError; ++i) {
                                is = null;
                                fileToZip = fileList[listSelected[i]];
                                Trace.trace(TRACE_MASKF, "file to zip =" + fileToZip + " i=" + i);
                                fileObj = new File(fileToZip);
                                try {
                                    is = new FileInputStream(fileToZip);
                                    ze = new ZipEntry(fileObj.getName());
                                    ze.setTime(fileObj.lastModified());
                                    if (zos == null) {
                                        try {
                                            zos = new ZipOutputStream(new FileOutputStream(tmpZipFile));
                                            zos.setMethod(8);
                                            zos.setComment("Compressed");
                                        }
                                        catch (IOException io) {
                                            Trace.trace(TRACE_MASKF, "IOException with zip file  File=" + tmpZipFileName);
                                            Trace.trace(TRACE_MASKF, io);
                                            zipError = true;
                                            this.displayMsg(panelTasklet, taskletResponse, _lZipFileTitle, "LOGDUZIP", MsgType.ERROR_MESSAGE);
                                        }
                                    }
                                    if (!zipError) {
                                        zos.putNextEntry(ze);
                                        while ((len = is.read(buf)) >= 0) {
                                            zos.write(buf, 0, len);
                                        }
                                        Trace.trace(TRACE_MASKF, "BEFORE closeEntry");
                                        zos.closeEntry();
                                        Trace.trace(TRACE_MASKF, "AFTER closeEntry");
                                        ++this._zipCount;
                                        Trace.trace(TRACE_MASKF, "Number of files zip'd so far =" + this._zipCount);
                                    }
                                    is = this.closeFile(is, fileToZip);
                                    continue;
                                }
                                catch (Exception fnf) {
                                    Trace.trace(TRACE_MASKF, fnf);
                                    this._badFiles.add(fileToZip);
                                    is = this.closeFile(is, fileToZip);
                                    Trace.trace(TRACE_MASKF, "problem while processing file=" + fileToZip);
                                }
                            }
                            try {
                                if (zos != null) {
                                    zos.close();
                                    zos = null;
                                }
                                if (!zipError) {
                                    if (deviceType != null) {
                                        this.writeToDevice(panelTasklet, taskletResponse, _lZipFileTitle, tmpZipFile, realZipFileName, ZIPPY);
                                    } else {
                                        this.respondToZipRequest(panelTasklet, taskletResponse, realZipFileName);
                                    }
                                    writeOk = true;
                                }
                            }
                            catch (IOException e) {
                                Trace.trace(TRACE_MASKF, "-> makeZipFile's finally. caught IOException on close");
                                Trace.trace(TRACE_MASKF, e);
                                if (zipError) break block30;
                                this.displayMsg(panelTasklet, taskletResponse, _lZipFileTitle, "LOGDUZIP", MsgType.ERROR_MESSAGE);
                            }
                        }
                        Object var23_27 = null;
                    }
                    catch (Throwable throwable) {
                        Object var23_28 = null;
                        Trace.trace(TRACE_MASKF, "-> makeZipFile()'s finally.");
                        if (busyDisplayed) {
                            panelTasklet.destroyBusyDialog();
                            busyDisplayed = false;
                        }
                        is = this.closeFile(is, fileToZip);
                        zos = this.closeZipStream(zos);
                        throw throwable;
                    }
                    Trace.trace(TRACE_MASKF, "-> makeZipFile()'s finally.");
                    if (busyDisplayed) {
                        panelTasklet.destroyBusyDialog();
                        busyDisplayed = false;
                    }
                    is = this.closeFile(is, fileToZip);
                    zos = this.closeZipStream(zos);
                    Object var25_30 = null;
                }
                catch (MediaServicesUtilException mse) {
                    Trace.trace(TRACE_MASKF, "in makeZipFile finally: Caught MediaServicesUtilException while querying device type.");
                    Trace.trace(TRACE_MASKF, mse);
                    Object var25_31 = null;
                    Trace.trace(TRACE_MASKF, "-> makeZipFile()'s final finally.");
                    if (!taskletResponse.isResponseSet()) {
                        taskletResponse.noAction();
                    }
                    if (tmpZipFile != null && (deviceType != null || deviceType == null && tmpZipFile.canWrite() && !writeOk && tmpZipFile.isFile())) {
                        tmpZipFile.delete();
                    }
                    break block32;
                }
            }
            catch (Throwable throwable) {
                Object var25_32 = null;
                Trace.trace(TRACE_MASKF, "-> makeZipFile()'s final finally.");
                if (!taskletResponse.isResponseSet()) {
                    taskletResponse.noAction();
                }
                if (tmpZipFile != null && (deviceType != null || deviceType == null && tmpZipFile.canWrite() && !writeOk && tmpZipFile.isFile())) {
                    tmpZipFile.delete();
                }
                throw throwable;
            }
            Trace.trace(TRACE_MASKF, "-> makeZipFile()'s final finally.");
            if (!taskletResponse.isResponseSet()) {
                taskletResponse.noAction();
            }
            if (tmpZipFile != null && (deviceType != null || deviceType == null && tmpZipFile.canWrite() && !writeOk && tmpZipFile.isFile())) {
                tmpZipFile.delete();
            }
        }
        Trace.trace(TRACE_MASKT, "<- FileFn.makeZipFile()");
    }

    private void respondToZipRequest(PanelTasklet panelTasklet, PanelTaskletResponse taskletResponse, String fileName) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> FileFn.respondToZipRequest(). zipCount=" + this._zipCount + " howManySelected=" + this._howManySelected);
        if (this._zipCount == 0) {
            Trace.trace(TRACE_MASKF, "None of the selected files were able to be zip'd");
            this.displayMsg(panelTasklet, taskletResponse, _lZipFileTitle, "LOGDUFIL", MsgType.ERROR_MESSAGE);
        } else if (this._zipCount != this._howManySelected) {
            Trace.trace(TRACE_MASKF, "Zip file created. Not all selected files part of zip file");
            BadFilesBean badFilesBean = new BadFilesBean();
            badFilesBean.setBadFiles(this._badFiles);
            taskletResponse.openModalChild(AUIML_FILE_NAME, BAD_FILES_PANEL_NAME, badFilesBean);
        } else {
            Trace.trace(TRACE_MASKF, "Zip operation successful");
            String[] arg = new String[]{fileName};
            this.displayMsg(panelTasklet, taskletResponse, _lZipFileTitle, "LOGDZIPC", arg, MsgType.INFORMATION_MESSAGE);
            if (!taskletResponse.isResponseSet()) {
                taskletResponse.dispose();
            }
        }
        Trace.trace(TRACE_MASKF, "<- FileFn.respondToZipRequest()");
    }

    private MediaDevice mediaSetup(PanelTasklet panelTasklet, String fileName) throws MediaServicesUtilException {
        Trace.trace(TRACE_MASKF, "-> mediaSetup()");
        this._releaseDevice = false;
        MediaDevice mediaDevice = null;
        LocalizableText locText = new LocalizableText("LogDisplayer" + new Date().getTime());
        Trace.trace(TRACE_MASKF, locText + " before issuing prepareMedia");
        mediaDevice = this._mediaServicesUtil.prepareMedia(this._mediaDeviceIdentifier, locText, true, null);
        Trace.trace(TRACE_MASKF, locText + " after issuing prepareMedia");
        this._releaseDevice = true;
        Trace.trace(TRACE_MASKF, "<- mediaSetup() releaseDevice=" + this._releaseDevice);
        return mediaDevice;
    }

    private void displayMsg(PanelTasklet panelTasklet, PanelTaskletResponse taskletResponse, LocalizableText title, String msgKey, MsgType msgType) throws TaskletException {
        BaseMessageText myMess = new BaseMessageText(msgKey);
        panelTasklet.showMessageBox(true, title, myMess, msgType, null);
    }

    private void displayMsg(PanelTasklet panelTasklet, PanelTaskletResponse taskletResponse, LocalizableText title, String msgKey, String[] args, MsgType msgType) throws TaskletException {
        BaseMessageText myMess = new BaseMessageText(msgKey, args);
        panelTasklet.showMessageBox(true, title, myMess, msgType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToDevice(PanelTasklet panelTasklet, PanelTaskletResponse taskletResponse, LocalizableText title, File tmpFile, String realFileName, String whoCalled) throws HException, TaskletException {
        Trace.trace(TRACE_MASKF, "writeToDevice() for: " + whoCalled);
        MediaDevice mediaDevice = null;
        boolean fileNameOk = true;
        if (whoCalled.equals(ZIPPY) && this._zipCount == 0) {
            this.respondToZipRequest(panelTasklet, taskletResponse, realFileName);
            Trace.trace(TRACE_MASKF, "Displayed msg: no files were accessable.");
        } else {
            try {
                String mountPoint;
                mediaDevice = this.mediaSetup(panelTasklet, realFileName);
                if (mediaDevice != null && (realFileName.equals(mountPoint = mediaDevice.getMountPoint().getAbsolutePath()) || realFileName.equals(mountPoint + File.separatorChar))) {
                    fileNameOk = false;
                    this.displayMsg(panelTasklet, taskletResponse, title, "LOGENFILE", MsgType.INFORMATION_MESSAGE);
                }
                if (fileNameOk) {
                    File realFile = new File(realFileName);
                    Trace.trace(TRACE_MASKF, "created File instance for " + realFileName);
                    FileUtilities.copy(tmpFile, realFile);
                    Trace.trace(TRACE_MASKF, "copied file to filename=" + realFileName);
                    this.doRelease("FileFn.writeToDevice()", mediaDevice);
                    if (whoCalled.equals(ZIPPY)) {
                        this.respondToZipRequest(panelTasklet, taskletResponse, realFileName);
                        Trace.trace(TRACE_MASKF, "The files have been zip'd.");
                    } else {
                        String[] arg = new String[]{realFileName};
                        this.displayMsg(panelTasklet, taskletResponse, title, "LOGDNFILE", arg, MsgType.INFORMATION_MESSAGE);
                        if (!taskletResponse.isResponseSet()) {
                            taskletResponse.dispose();
                        }
                        Trace.trace(TRACE_MASKF, "The data has been saved to the file=" + realFileName);
                    }
                }
            }
            catch (MediaServicesUtilException mse) {
                Trace.trace(TRACE_MASKF, "MediaServicesUtilException caught in FileFn.writeToDevice() errorType=" + mse.getErrorType());
                Trace.trace(TRACE_MASKF, mse);
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "IOException caught in FileFn.writeToDevice() ");
                Trace.trace(TRACE_MASKF, e);
                if (whoCalled.equals(ZIPPY)) {
                    this.displayMsg(panelTasklet, taskletResponse, title, "LOGDUZIP", MsgType.ERROR_MESSAGE);
                    Trace.trace(TRACE_MASKF, "Error creating the zip file.");
                } else {
                    this.displayMsg(panelTasklet, taskletResponse, title, "LOGDUFILE", MsgType.ERROR_MESSAGE);
                    Trace.trace(TRACE_MASKF, "Error saving the file data.");
                }
            }
            finally {
                this.doRelease("ensureUnlocked:FileFn.writeToDevice()", mediaDevice);
            }
        }
    }

    public String queryMediaType(PanelTasklet panelTasklet, String fileName) throws MediaServicesUtilException {
        Trace.trace(TRACE_MASKF, "-> FileFn.queryMediaType()");
        String deviceType = null;
        this._mediaServicesUtil = new MediaServicesUtil(panelTasklet);
        Trace.trace(TRACE_MASKF, "Before queryMediaDevicePath()");
        this._mediaDeviceIdentifier = this._mediaServicesUtil.queryMediaDevicePath(fileName);
        if (this._mediaDeviceIdentifier == null) {
            Trace.trace(TRACE_MASKF, "mediaDeviceIdentifier is null");
        } else {
            deviceType = this._mediaDeviceIdentifier.getDeviceType();
            if (deviceType == null) {
                Trace.trace(TRACE_MASKF, "Device type returned was null");
            } else {
                Trace.trace(TRACE_MASKF, "Device type=" + deviceType);
                if (!deviceType.equals("DD") && !deviceType.equals("DV")) {
                    deviceType = null;
                    Trace.trace(TRACE_MASKF, "We will assume that it is a hard drive");
                }
            }
        }
        Trace.trace(TRACE_MASKF, "<- FileFn.queryMediaType()");
        return deviceType;
    }

    private FileInputStream closeFile(FileInputStream is, String fileName) {
        try {
            if (is != null) {
                is.close();
            }
            is = null;
        }
        catch (IOException ioe) {
            Trace.trace(TRACE_MASKF, "Problem closing file=" + fileName);
            is = null;
        }
        return is;
    }

    private ZipOutputStream closeZipStream(ZipOutputStream zos) {
        try {
            if (zos != null) {
                zos.close();
            }
            zos = null;
        }
        catch (IOException ioe) {
            Trace.trace(TRACE_MASKF, "Problem closing zip output stream");
            zos = null;
        }
        return zos;
    }

    public static String fullyQualify(String fileName) {
        Trace.trace(TRACE_MASKT, "-> FileFn.fullyQualify()");
        if (!fileName.startsWith(File.separator)) {
            String path = System.getProperty("CONSOLE_PATH");
            if (path != null) {
                fileName = path + fileName;
                Trace.trace(TRACE_MASKF, "Fully qualified name selected=" + fileName);
            } else {
                Trace.trace(TRACE_MASKF, "Can't get the prefix path .");
            }
        }
        Trace.trace(TRACE_MASKT, "<- FileFn.fullyQualify()");
        return fileName;
    }
}

